package de.qfs
import java.util.Map
import de.qfs.lib.notifications.DefaultNotification.ExceptionHandler
import java.util.List
/**
 * User notifications provide a simple API for posting and handling notifications
 * from user scripts.
 * 
 * Notifications are identified by a name, e.g. "user.sut.login" and provide a
 * userInfo map, which can hold arbitrary key-value pairs.
 * 
 * To post notifications, use notification.post(notificationName, userInfo).
 * 
 * To observe notifications, add an observer method using
 * addObserver(nameOfObserver, observerMethod, notificationName)
 */
class UserNotifications{
    //  redirected constants
    static public final String NOTIFICATION_PREFIX = de.qfs.apps.qftest.shared.script.modules.UserNotifications.NOTIFICATION_PREFIX
    static public final String RECORDING_STARTED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.RECORDING_STARTED
    static public final String RECORDING_STOPPED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.RECORDING_STOPPED
    static public final String RECORDING_PAUSED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.RECORDING_PAUSED
    static public final String RECORDING_RESUMED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.RECORDING_RESUMED
    static public final String CHECK_RECORDING_STARTED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.CHECK_RECORDING_STARTED
    static public final String CHECK_RECORDING_STOPPED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.CHECK_RECORDING_STOPPED
    static public final String REQUEST_RECORDING_STARTED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.REQUEST_RECORDING_STARTED
    static public final String REQUEST_RECORDING_STOPPED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.REQUEST_RECORDING_STOPPED
    static public final String COMPONENT_RECORDING_STARTED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.COMPONENT_RECORDING_STARTED
    static public final String COMPONENT_RECORDING_STOPPED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.COMPONENT_RECORDING_STOPPED
    static public final String PROCBUILDER_STARTED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.PROCBUILDER_STARTED
    static public final String PROCBUILDER_STOPPED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.PROCBUILDER_STOPPED
    static public final String INSPECTOR_MODE_STARTED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.INSPECTOR_MODE_STARTED
    static public final String INSPECTOR_MODE_STOPPED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.INSPECTOR_MODE_STOPPED
    static public final String INSPECTOR_UPDATE_PROGRESS_BAR = de.qfs.apps.qftest.shared.script.modules.UserNotifications.INSPECTOR_UPDATE_PROGRESS_BAR
    static public final String RUN_STARTED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.RUN_STARTED
    static public final String RUN_STOPPED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.RUN_STOPPED
    static public final String NODE_ENTERED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.NODE_ENTERED
    static public final String NODE_EXITED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.NODE_EXITED
    static public final String RUN_ERROR_OCCURED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.RUN_ERROR_OCCURED
    static public final String SUITE_LOADED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.SUITE_LOADED
    static public final String RUN_LOG_LOADED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.RUN_LOG_LOADED
    /**
     * Used to trigger a script execution in QF-Test.
     * 
     * User-Info members:
     * * code: The code to execute
     * * interpreter: Interpreter name, defaults to the standard scripting language
     * * async: true/false, to execute the script asynchronously
     * * client: Client name, if the script should be executed as a SUT-Script.
     * * engine: If executed as SUT-script can specify the engine to execute the script in
     */
    static public final String EXECUTE = de.qfs.apps.qftest.shared.script.modules.UserNotifications.EXECUTE
    /**
     * Used to influence the messages logged by QF-Test
     * 
     * User-Info members:
     * * errorLevel: The error level of the message (readOnly)
     * * message: The message to log
     * * messageParameters: List of parameters for the message
     * * localMessage: The message in the current set locale.
     * If modified, it overrides any change to message or messageParameters
     * * dontcompactify: true/false, determines if message is protected from log compactification
     * * report: true/false, determines if log is visible in the report. Always true for errors and exceptions.
     * * nowrap: true/false, determines if line wrapping should be prevented
     * * suppress: true/false, determines if message is logged at all
     */
    static public final String LOG_MESSAGE = de.qfs.apps.qftest.shared.script.modules.UserNotifications.LOG_MESSAGE
    /**
     * Called when the operating system changed it's color theme or when the system asks applications to adapt their color theme (light/dark)
     * 
     * User info values:
     * * didChangeAppsTheme: true/false
     * * appsAreInDarkMode: true/false
     * * didChangeSystemTheme: true/false
     * * systemIsInDarkMode: true/false
     */
    static public final String SYSTEM_THEME_CHANGED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.SYSTEM_THEME_CHANGED
    /**
     * Called on the Swing Dispatch Thread when the QF-Test theme is about to change.
     * 
     * User info values:
     * * theme: Name of the new theme
     * * isDarkTheme: true/false
     */
    static public final String QFTEST_THEME_WILL_CHANGE = de.qfs.apps.qftest.shared.script.modules.UserNotifications.QFTEST_THEME_WILL_CHANGE
    /**
     * Called on the Swing Dispatch Thread when the QF-Test theme was changed.
     * 
     * User info values:
     * * theme: Name of the new theme
     * * isDarkTheme: true/false
     */
    static public final String QFTEST_THEME_CHANGED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.QFTEST_THEME_CHANGED
    /**
     * Called on the Swing Dispatch Thread when the QF-Test theme was changed and the ui components have been updated.
     * 
     * User info values:
     * * theme: Name of the new theme
     * * isDarkTheme: true/false
     */
    static public final String QFTEST_THEME_UPDATED_UI = de.qfs.apps.qftest.shared.script.modules.UserNotifications.QFTEST_THEME_UPDATED_UI
    /**
     * Called on the Swing Dispatch Thread when the QF-Test theme was initially set
     * 
     * User info values:
     * * theme: Name of the new theme
     * * isDarkTheme: true/false
     */
    static public final String QFTEST_THEME_INITIALIZED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.QFTEST_THEME_INITIALIZED
    /**
     * Sent when qfapp code will be injected. Put a member <code>code</code> into the userInfo
     * to inject it as qfapp code.
     */
    static public final String INJECTING_CODE = de.qfs.apps.qftest.shared.script.modules.UserNotifications.INJECTING_CODE
    /**
     * Sent when a window is about to be raised. Put a member <code>didRaise</code> into the userInfo
     * to prevent QF-Test raising the window.
     */
    static public final String WINDOW_RAISE = de.qfs.apps.qftest.shared.script.modules.UserNotifications.WINDOW_RAISE
    /**
     * Called as soon as the application tries to open an external webbrowser to display a website.
     * The userInfo contains the members "url" - a String pointing to the URL to open (read only) - and
     * "open" - a Boolean which can be set to "FALSE" to prohibit the actual browser opening.
     */
    static public final String BROWSER_OPEN = de.qfs.apps.qftest.shared.script.modules.UserNotifications.BROWSER_OPEN
    /**
     * Called as soon as the application tries to open a file using the java.awt.Desktop API.
     * The userInfo contains the members "file" - the File object to open (read only) - and
     * "open" - a Boolean which can be set to "FALSE" to prohibit the actual file opening.
     */
    static public final String FILE_OPEN = de.qfs.apps.qftest.shared.script.modules.UserNotifications.FILE_OPEN
    /**
     * Called as soon as the application is about to start an external process.
     * 
     * The userInfo contains the following entries:
     * * command - A List of Strings of the command to start (modifiable/replaceable)
     * * directory - A File with the process working directory (or null) (replaceable)
     * * environment - A Map of String-String entries representing the environment passed to the process (modifiable/replaceable)
     * 
     * These entries can be added to the userInfo:
     * * stdout - If set, a mock process is started which returns the given String on STDOUT
     * * stderr - If set, a mock process is started which returns the given String on STDERR
     * * exitcode - If set, a mock process is started which returns with the given exit code
     * * runtime - If set, a mock process is started which returns after the given runtime (in milliseconds)
     * * ioexception - If set, instead of starting the process the given exception is thrown (can be a String)
     */
    static public final String PROCESS_START = de.qfs.apps.qftest.shared.script.modules.UserNotifications.PROCESS_START
    /**
     * Called if a client opened a new remote inspector.
     * 
     * User info values:
     * * clientName: Name of the Client.
     * * engineName: Name of the Engine.
     * * idToSelect: ID of the UiComponent to select.
     * * triggeredByInspectorMode: true if selection was triggered by the inspector mode.
     */
    static public final String REMOTE_INSPECTOR_CONNECTED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.REMOTE_INSPECTOR_CONNECTED
    /**
     * Called if a client want to inspect a component.
     * 
     * User info values:
     * * clientName: Name of the Client.
     * * engineName: Name of the Engine.
     * * idToSelect: ID of the UiComponent to select.
     * * triggeredByInspectorMode: true if selection was triggered by the inspector mode.
     * * skipHighlight: true if the highlighting should be prevented.
     */
    static public final String INSPECTOR_SELECT = de.qfs.apps.qftest.shared.script.modules.UserNotifications.INSPECTOR_SELECT
    /**
     * Called if a client closed a inspector.
     * 
     * User info values:
     * * clientName: Name of the Client.
     */
    static public final String INSPECTOR_DISCONNECTED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.INSPECTOR_DISCONNECTED
    /**
     * Called when the inspector has changed its visibility status(change client menu checkbox).
     * 
     * User info values:
     * * clientName: Name of the Client.
     * * engineType: Name of the Engine.
     * * show: true for show, false for hide.
     * * skipCounter: if true the inspector counter should not be adjusted.
     */
    static public final String INSPECTOR_WINDOW_CHANGED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.INSPECTOR_WINDOW_CHANGED
    /**
     * Called if a client want to hide the inspector.
     * 
     * User info values:
     * * clientName: Name of the Client.
     * * engineType: Name of the Engine.
     */
    static public final String INSPECTOR_HIDE_WINDOW = de.qfs.apps.qftest.shared.script.modules.UserNotifications.INSPECTOR_HIDE_WINDOW
    /**
     * Called as soon as a request is about to be sent from the browser.
     * 
     * The userInfo contains the following entries:
     * * url - The url called by the browser - (replaceable)
     * * method - The method used to request (replaceable)
     * * postData - A String containing the post data, if available (replaceable)
     * * resourceType - the requested resource - one of Document, Stylesheet, Image, Media, Font, Script, TextTrack, XHR, Fetch, EventSource, WebSocket, Manifest, SignedExchange, Ping, CSPViolationReport, Preflight, Other
     * * requestHeaders - A Map of String-String entries representing the headers sent with the request (modifiable/replaceable)
     * 
     * These entries can be added to the userInfo:
     * * errorReason - If set, the request fails with the given reason. Allowed values: Failed, Aborted, TimedOut, AccessDenied, ConnectionClosed, ConnectionReset, ConnectionRefused, ConnectionAborted, ConnectionFailed, NameNotResolved, InternetDisconnected, AddressUnreachable, BlockedByClient, BlockedByResponse
     * * responseCode - If set, the request will be fulfilled with the given response status code, e.g. "404"
     * * responseHeaders - If set, the request will be fulfilled with the given response headers (Should be a String or a Map of String-String entries)
     * * responseBody (String or byte[]) - If set, the request will be fulfilled with the given body.
     * * interceptResponse - If set to false, the corresponding response will not be intercepted.
     * 
     * Only available when CDP-Driver is used to connect the browser.
     */
    static public final String WEB_REQUEST_RECEIVED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.WEB_REQUEST_RECEIVED
    /**
     * Simple variation of WEB_RESPONSE_RECEIVED, called upon CDPs Fetch.requestPaused event, only contains
     * the parsed event data as "value" entry, and the request is continued without modification.
     */
    static public final String WEB_REQUEST_RECEIVED_TRACKONLY = de.qfs.apps.qftest.shared.script.modules.UserNotifications.WEB_REQUEST_RECEIVED_TRACKONLY
    /**
     * Called as soon as a request is responded from the server to the browser.
     * 
     * The userInfo contains all information as described for WEB_REQUEST_RECEIVED.
     * 
     * In addition, the following entries are prefilled:
     * * errorReason - Only in case of error (replaceable)
     * * responseCode - If available (replaceable)
     * * responseHeaders - The headers returned from the server (replaceable)
     * * responseBodyAccessor - An object who's "get()"-Method returns the body of the response (String or byte[])
     * 
     * Information: Only modify the response headers or request the responseBody if the request content is
     * about to be small to avoid OutOfMemory errors, since the complete body will go through QF-Test
     * for technical reasons.
     * 
     * Only available when CDP-Driver is used to connect the browser.
     */
    static public final String WEB_RESPONSE_RECEIVED = de.qfs.apps.qftest.shared.script.modules.UserNotifications.WEB_RESPONSE_RECEIVED
    /**
     * Simple variation of WEB_RESPONSE_RECEIVED, called upon CDPs Fetch.requestPaused event, only contains
     * the parsed event data as "value" entry, and the request is continued without modification.
     */
    static public final String WEB_RESPONSE_RECEIVED_TRACKONLY = de.qfs.apps.qftest.shared.script.modules.UserNotifications.WEB_RESPONSE_RECEIVED_TRACKONLY
    static public final String CREATING_WEBDRIVER = de.qfs.apps.qftest.shared.script.modules.UserNotifications.CREATING_WEBDRIVER
    static public final String CREATING_CDPDRIVER = de.qfs.apps.qftest.shared.script.modules.UserNotifications.CREATING_CDPDRIVER
    /**
     * Triggered after a CDP browser has been started and the connection URL has been determined. Allows to adapt the
     * connection URL before the CDP connection is established.
     * 
     * The userInfo contains the following entries:
     * * url - The url used to create a websocket connection - (replaceable)
     * 
     * These entries can be added to the userInfo:
     * * connection - a com.cdp4j.channel.Connection Object which can be used in place of the
     */
    static public final String PRECONNECT_CDPDRIVER = de.qfs.apps.qftest.shared.script.modules.UserNotifications.PRECONNECT_CDPDRIVER
    /** The ExceptionHandler logs to run log and catches any exception */
    static public final ExceptionHandler LOGGING_EXCEPTION_HANDLER = de.qfs.apps.qftest.shared.script.modules.UserNotifications.LOGGING_EXCEPTION_HANDLER
    /**
     * Called if a emulator connection should be checked.
     * 
     * User info values:
     * * engineName: name of the engine(android/ios).
     */
    static public final String VERIFY_EMULATOR_CONNECTION = de.qfs.apps.qftest.shared.script.modules.UserNotifications.VERIFY_EMULATOR_CONNECTION
    //  redirected methods
    private final de.qfs.apps.qftest.shared.script.modules.UserNotifications __wrappedInstance
    private static UserNotifications __instance = new UserNotifications()
    static UserNotifications instance(){
        return __instance
    }
    private UserNotifications(){
        __wrappedInstance = de.qfs.apps.qftest.shared.script.modules.UserNotifications.instance()
    }
    /**
     * Posts a new notification.
     * 
     * @param notficationName the name of the notification. If it does not start with "user.",
     * it is prefixed with this string.
     * @param userInfo An optional map of data to attach to the notification
     */
    public void post(String notificationName, Map userInfo=null){
        __wrappedInstance.post(notificationName, userInfo)
    }
    /**
     * Posts a new notification.
     * 
     * @param notficationName the name of the notification. If it does not start with "user.",
     * it is prefixed with this string.
     * @param userInfo An optional map of data to attach to the notification
     */
    public void post(Map mappedParams, String notificationName){
        __wrappedInstance.post(notificationName, mappedParams)
    }
    /**
     * Adds a notification observer with the given name for the given notificationNames
     * 
     * @param observerName the name of the observer
     * @param observer the method to call when a notification is posted. The method receives the name of the
     * posted notification as first argument and the userInfo map as second argument. If the observer
     * specifies only one argument, the userInfo map is provided as first parameter.
     * @param notificationNames the names of the notifications to be informed when posted. If a name does not
     * start with "user.", it is prefixed with this string. If no notification names are provided, the observerName
     * is used as notification name.
     */
    public void addObserver(String observerName, Object method, String... notificationNames){
        __wrappedInstance.addObserver(observerName, method, notificationNames)
    }
    /**
     * Removes the notification observer added before with the given name
     * 
     * @param observerName the name of the observer to remove
     */
    public void removeObserver(String observerName){
        __wrappedInstance.removeObserver(observerName)
    }
    /** Remove all previously registered observers */
    public void removeAllObserver(){
        __wrappedInstance.removeAllObserver()
    }
    /** List the names of all registered observers */
    public List<String> listObserverNames(){
        return __wrappedInstance.listObserverNames()
    }
}
