import de.qfs.Resolvers
import de.qfs.RunEngine
import de.qfs.SutContext
import de.qfs.UserNotifications

qf = de.qfs.QF
Options = de.qfs.apps.qftest.shared.extensions.Options

SutContext.metaClass.withDefault = {
    def newRc = new SutContext("groovy")
    newRc._setDefaultResult(it)
    return newRc
}
rc = new SutContext("groovy")
qf.setRCProvider({new SutContext("groovy")})

resolvers = Resolvers.instance()
notifications = UserNotifications.instance()
try {
    JSON = this.class.classLoader.loadClass("de.qfs.JSONModule")
} catch (e) {}

runAndroid = { cmd, timeout= 5000 -> RunEngine.runAndroid("groovy", cmd, timeout)
}
runAWT = { cmd, timeout= 5000 -> RunEngine.runAWT("groovy", cmd, timeout)
}
runSWT = { cmd, timeout= 5000 -> RunEngine.runSWT("groovy", cmd, timeout)
}
runWeb = { cmd, timeout= 5000 -> RunEngine.runWeb("groovy", cmd, timeout)
}
runFX = { cmd, timeout= 5000 -> RunEngine.runFX("groovy", cmd, timeout)
}
runIOS = { cmd, timeout= 5000 -> RunEngine.runIOS("groovy", cmd, timeout)
}
runWin = { cmd, timeout= 5000 -> RunEngine.runWin("groovy", cmd, timeout)
}

try {
    expect = {
        return de.qfs.lib.assertions.Expect.expect(it)
    }
    Assert = de.qfs.lib.assertions.Assert
} catch (e) {}
try {
    ai = new de.qfs.AI()
} catch (e) {}