from de.qfs.apps.qftest.shared.script.modules import AI as _WrappedAI
class AI(object):
    #  redirected constants
    #  redirected methods
    def __init__(self):
        self.__wrappedInstance = _WrappedAI.instance()

    def setDefaultConfig(self, provider, baseUrl, apiKey, modelName, displayName=None):
        """
        Define a default AI configuration to use instead of the first one configured in Options > Artificial Intelligence

        @param provider      Currently available provider types: <code>OpenAIGeneric</code>, <code>Anthropic</code>, <code>Gemini</code> and <code>Ollama</code>
        @param baseUrl       The base API URL endpoint to the provider. Usually ends with <code>/v1</code> oder similar
        @param apiKey        The API key to submit to the provider
        @param modelName     The name of the model to use, like <code>gpt-4o</code> or <code>gemini-2.0-flash</code>
        @param displayName   How QF-Test will identify the configuration in logs and error messages, defaults to <code>Default</code>
        """
        self.__wrappedInstance.setDefaultConfig(provider, baseUrl, apiKey, modelName, displayName)

    def resetDefaultConfig(self):
        """
        Reset the default AI configuration previously set via ai.setDefaultConfig
        to use the first one defined in Options > Artificial Intelligence
        """
        self.__wrappedInstance.resetDefaultConfig()

    def getConfigNames(self):
        """ Returns a list of all available AI configuration names"""
        return self.__wrappedInstance.getConfigNames()

    def ask(self, message, configName=None, temperature=None, topP=None, topK=None, frequencyPenalty=None, presencePenalty=None, maxOutputTokens=None, stopSequences=None, timeoutMs=None):
        """
        Sends a message to a LLM model and returns the response

        @param message       The message to send to the LLM
        @param configName    The name of an AI configuration as set in Options > Artificial Intelligence. Defaults to the first one or to the one set via ai.setDefaultConfig
        @param temperature   Optionally controls the randomness of the generated text
        @param topP          Optionally controls how many of the most likely tokens should be considered
        @param topK          Optionally controls which tokens should be considered
        @param frequencyPenalty  Optionally prevents the LLM from reusing words
        @param presencePenalty   Optionally prevents the LLM from repeating words
        @param maxOutputTokens   Optional maximum number of tokens that can be generated in the response
        @param stopSequences     Optionally prevents LLM from generating more text after that string appears
        @param timeoutMs         How long to wait for a response from the LLM
        """
        return self.__wrappedInstance.ask(message, configName, temperature, topP, topK, frequencyPenalty, presencePenalty, maxOutputTokens, stopSequences, timeoutMs)

    def addCustomModel(self, name, responseFunction):
        """
        Adds a custom model to the list of defined AI configurations

        @param name The AI configuration name under which the custom model can be referenced
        @param responseFunction A function which receives the query -
        its first parameter is the request itself, an optional second parameter holds the request parameters
        """
        self.__wrappedInstance.addCustomModel(name, responseFunction)

    def removeCustomModel(self, name):
        """
        Removes the custom model from the list of defined models
        @param name The name under which the custom model was registered
        """
        self.__wrappedInstance.removeCustomModel(name)


