from de.qfs.apps.qftest.shared.script.modules import JSONModule as _WrappedJSONModule
#  redirected constants
#  redirected methods
def parse(text, reviver=None):
    """
    The JSON.parse() static method parses a JSON string, constructing the Object value or object described by the string.
    If called from Javascript, the original Javascript version of JSON.parse is used.

    @param text      The String or InputStream to parse as JSON.
    @param reviver   If a function, this prescribes how each value originally produced by parsing is transformed before being returned.
    Non-callable values are ignored.

    @implNote
    If a reviver is specified, the value computed by parsing is transformed before being returned. Specifically, the computed value and all its properties
    (in a depth-first fashion, beginning with the most nested properties and proceeding to the original value itself) are individually run through the reviver.
    The reviver is called with two arguments: key and value, representing the property name as a string (even for Lists) and the property value.
    If the reviver function throws a NoSuchElementException, the property is deleted from the object (or replaced by null in a list),
    if it throws an UnsupportedOperationException, the value is unchanged.
    Otherwise, the property is redefined to be the return value.
    If the reviver only transforms some values and not others, be certain to return all untransformed values as-is or throw an UnsupportedOperationException.
    Otherwise, they will be deleted from the resulting object.
    Similar to the replacer parameter of JSON.stringify(), for Lists and Maps, reviver will be last called on the root value with an empty string as the key and the root object as the value.
    For other valid JSON values, reviver works similarly and is called once with an empty string as the key and the value itself as the value.
    If you return another value from reviver, that value will completely replace the originally parsed value. This even applies to the root value.

    @return The Map, List, String, Number, Boolean, or null value corresponding to the given JSON text.
    """
    return _WrappedJSONModule.parse(text, reviver)

def stringify(value, replacer=None, space=None):
    """
    The JSON.stringify() static method converts an object into a JSON string.
    If called from Javascript, the original Javascript version of JSON.parse is used.

    @param value     The value to convert to a JSON string.
    @param replacer  A function that alters the behavior of the stringification process, or an array of strings and numbers that specifies properties of value to be included in the output.
    If replacer is anything other than a function or an array, all string-keyed properties of the object are included in the resulting JSON string.

    @param space     (Optional) A string or number that's used to insert white space (including indentation, line break characters, etc.)
    into the output JSON string for readability purposes.<br>
    If this is a number, it indicates the number of space characters to be used as indentation, clamped to 10 (that is, any number greater than 10 is treated as if it were 10). Values less than 1 indicate that no space should be used.<br>
    If this is a string, the string (or the first 10 characters of the string, if it's longer than that) is inserted before every nested object or array.<br>
    If space is anything other than a string or number - for example, is null or not provided - no white space is used.

    @implNote
    The replacer parameter can be either a function or an array.
    As an array, its elements indicate the names of the properties in the object that should be included in the resulting JSON string.
    Only string and number values are taken into account.

    As a function, it takes two parameters: the key and the value being stringified.

    The replacer function is called for the initial object being stringified as well, in which case the key is an empty string ("").
    It is then called for each property on the object or array being stringified.
    The current property value will be replaced with the replacer's return value for stringification. This means:

    If you return a number, string, boolean, or null, that value is directly serialized and used as the property's value.
    If you throw a NoSuchElementException, the property is not included in the output.
    If you return any other object, the object is recursively stringified, calling the replacer function on each property.

    Note: When parsing JSON generated with replacer functions, you would likely want to use the reviver parameter to perform the reverse operation.

    Typically, array elements' index would never shift (even when the element is an invalid value like a function, it will become null instead of omitted).
    Using the replacer function allows you to control the order of the array elements by returning a different array.

    @return A JSON string representing the given value, or null.
    """
    return _WrappedJSONModule.stringify(value, replacer, space)

