from de.qfs.apps.qftest.shared.script.modules import UserNotifications as _WrappedUserNotifications
#  redirected constants
NOTIFICATION_PREFIX = _WrappedUserNotifications.NOTIFICATION_PREFIX
RECORDING_STARTED = _WrappedUserNotifications.RECORDING_STARTED
RECORDING_STOPPED = _WrappedUserNotifications.RECORDING_STOPPED
RECORDING_PAUSED = _WrappedUserNotifications.RECORDING_PAUSED
RECORDING_RESUMED = _WrappedUserNotifications.RECORDING_RESUMED
CHECK_RECORDING_STARTED = _WrappedUserNotifications.CHECK_RECORDING_STARTED
CHECK_RECORDING_STOPPED = _WrappedUserNotifications.CHECK_RECORDING_STOPPED
REQUEST_RECORDING_STARTED = _WrappedUserNotifications.REQUEST_RECORDING_STARTED
REQUEST_RECORDING_STOPPED = _WrappedUserNotifications.REQUEST_RECORDING_STOPPED
COMPONENT_RECORDING_STARTED = _WrappedUserNotifications.COMPONENT_RECORDING_STARTED
COMPONENT_RECORDING_STOPPED = _WrappedUserNotifications.COMPONENT_RECORDING_STOPPED
PROCBUILDER_STARTED = _WrappedUserNotifications.PROCBUILDER_STARTED
PROCBUILDER_STOPPED = _WrappedUserNotifications.PROCBUILDER_STOPPED
INSPECTOR_MODE_STARTED = _WrappedUserNotifications.INSPECTOR_MODE_STARTED
INSPECTOR_MODE_STOPPED = _WrappedUserNotifications.INSPECTOR_MODE_STOPPED
INSPECTOR_UPDATE_PROGRESS_BAR = _WrappedUserNotifications.INSPECTOR_UPDATE_PROGRESS_BAR
RUN_STARTED = _WrappedUserNotifications.RUN_STARTED
RUN_STOPPED = _WrappedUserNotifications.RUN_STOPPED
NODE_ENTERED = _WrappedUserNotifications.NODE_ENTERED
NODE_EXITED = _WrappedUserNotifications.NODE_EXITED
RUN_ERROR_OCCURED = _WrappedUserNotifications.RUN_ERROR_OCCURED
SUITE_LOADED = _WrappedUserNotifications.SUITE_LOADED
RUN_LOG_LOADED = _WrappedUserNotifications.RUN_LOG_LOADED
"""
Used to trigger a script execution in QF-Test.

User-Info members:
* code: The code to execute
* interpreter: Interpreter name, defaults to the standard scripting language
* async: true/false, to execute the script asynchronously
* client: Client name, if the script should be executed as a SUT-Script.
* engine: If executed as SUT-script can specify the engine to execute the script in
"""
EXECUTE = _WrappedUserNotifications.EXECUTE
"""
Used to influence the messages logged by QF-Test

User-Info members:
* errorLevel: The error level of the message (readOnly)
* message: The message to log
* messageParameters: List of parameters for the message
* localMessage: The message in the current set locale.
If modified, it overrides any change to message or messageParameters
* dontcompactify: true/false, determines if message is protected from log compactification
* report: true/false, determines if log is visible in the report. Always true for errors and exceptions.
* nowrap: true/false, determines if line wrapping should be prevented
* suppress: true/false, determines if message is logged at all
"""
LOG_MESSAGE = _WrappedUserNotifications.LOG_MESSAGE
"""
Called when the operating system changed it's color theme or when the system asks applications to adapt their color theme (light/dark)

User info values:
* didChangeAppsTheme: true/false
* appsAreInDarkMode: true/false
* didChangeSystemTheme: true/false
* systemIsInDarkMode: true/false
"""
SYSTEM_THEME_CHANGED = _WrappedUserNotifications.SYSTEM_THEME_CHANGED
"""
Called on the Swing Dispatch Thread when the QF-Test theme is about to change.

User info values:
* theme: Name of the new theme
* isDarkTheme: true/false
"""
QFTEST_THEME_WILL_CHANGE = _WrappedUserNotifications.QFTEST_THEME_WILL_CHANGE
"""
Called on the Swing Dispatch Thread when the QF-Test theme was changed.

User info values:
* theme: Name of the new theme
* isDarkTheme: true/false
"""
QFTEST_THEME_CHANGED = _WrappedUserNotifications.QFTEST_THEME_CHANGED
"""
Called on the Swing Dispatch Thread when the QF-Test theme was changed and the ui components have been updated.

User info values:
* theme: Name of the new theme
* isDarkTheme: true/false
"""
QFTEST_THEME_UPDATED_UI = _WrappedUserNotifications.QFTEST_THEME_UPDATED_UI
"""
Called on the Swing Dispatch Thread when the QF-Test theme was initially set

User info values:
* theme: Name of the new theme
* isDarkTheme: true/false
"""
QFTEST_THEME_INITIALIZED = _WrappedUserNotifications.QFTEST_THEME_INITIALIZED
"""
Sent when qfapp code will be injected. Put a member <code>code</code> into the userInfo
to inject it as qfapp code.
"""
INJECTING_CODE = _WrappedUserNotifications.INJECTING_CODE
"""
Sent when a window is about to be raised. Put a member <code>didRaise</code> into the userInfo
to prevent QF-Test raising the window.
"""
WINDOW_RAISE = _WrappedUserNotifications.WINDOW_RAISE
"""
Called as soon as the application tries to open an external webbrowser to display a website.
The userInfo contains the members "url" - a String pointing to the URL to open (read only) - and
"open" - a Boolean which can be set to "FALSE" to prohibit the actual browser opening.
"""
BROWSER_OPEN = _WrappedUserNotifications.BROWSER_OPEN
"""
Called as soon as the application tries to open a file using the java.awt.Desktop API.
The userInfo contains the members "file" - the File object to open (read only) - and
"open" - a Boolean which can be set to "FALSE" to prohibit the actual file opening.
"""
FILE_OPEN = _WrappedUserNotifications.FILE_OPEN
"""
Called as soon as the application is about to start an external process.

The userInfo contains the following entries:
* command - A List of Strings of the command to start (modifiable/replaceable)
* directory - A File with the process working directory (or null) (replaceable)
* environment - A Map of String-String entries representing the environment passed to the process (modifiable/replaceable)

These entries can be added to the userInfo:
* stdout - If set, a mock process is started which returns the given String on STDOUT
* stderr - If set, a mock process is started which returns the given String on STDERR
* exitcode - If set, a mock process is started which returns with the given exit code
* runtime - If set, a mock process is started which returns after the given runtime (in milliseconds)
* ioexception - If set, instead of starting the process the given exception is thrown (can be a String)
"""
PROCESS_START = _WrappedUserNotifications.PROCESS_START
"""
Called if a client opened a new remote inspector.

User info values:
* clientName: Name of the Client.
* engineName: Name of the Engine.
* idToSelect: ID of the UiComponent to select.
* triggeredByInspectorMode: true if selection was triggered by the inspector mode.
"""
REMOTE_INSPECTOR_CONNECTED = _WrappedUserNotifications.REMOTE_INSPECTOR_CONNECTED
"""
Called if a client want to inspect a component.

User info values:
* clientName: Name of the Client.
* engineName: Name of the Engine.
* idToSelect: ID of the UiComponent to select.
* triggeredByInspectorMode: true if selection was triggered by the inspector mode.
* skipHighlight: true if the highlighting should be prevented.
"""
INSPECTOR_SELECT = _WrappedUserNotifications.INSPECTOR_SELECT
"""
Called if a client closed a inspector.

User info values:
* clientName: Name of the Client.
"""
INSPECTOR_DISCONNECTED = _WrappedUserNotifications.INSPECTOR_DISCONNECTED
"""
Called when the inspector has changed its visibility status(change client menu checkbox).

User info values:
* clientName: Name of the Client.
* engineType: Name of the Engine.
* show: true for show, false for hide.
* skipCounter: if true the inspector counter should not be adjusted.
"""
INSPECTOR_WINDOW_CHANGED = _WrappedUserNotifications.INSPECTOR_WINDOW_CHANGED
"""
Called if a client want to hide the inspector.

User info values:
* clientName: Name of the Client.
* engineType: Name of the Engine.
"""
INSPECTOR_HIDE_WINDOW = _WrappedUserNotifications.INSPECTOR_HIDE_WINDOW
"""
Called as soon as a request is about to be sent from the browser.

The userInfo contains the following entries:
* url - The url called by the browser - (replaceable)
* method - The method used to request (replaceable)
* postData - A String containing the post data, if available (replaceable)
* resourceType - the requested resource - one of Document, Stylesheet, Image, Media, Font, Script, TextTrack, XHR, Fetch, EventSource, WebSocket, Manifest, SignedExchange, Ping, CSPViolationReport, Preflight, Other
* requestHeaders - A Map of String-String entries representing the headers sent with the request (modifiable/replaceable)

These entries can be added to the userInfo:
* errorReason - If set, the request fails with the given reason. Allowed values: Failed, Aborted, TimedOut, AccessDenied, ConnectionClosed, ConnectionReset, ConnectionRefused, ConnectionAborted, ConnectionFailed, NameNotResolved, InternetDisconnected, AddressUnreachable, BlockedByClient, BlockedByResponse
* responseCode - If set, the request will be fulfilled with the given response status code, e.g. "404"
* responseHeaders - If set, the request will be fulfilled with the given response headers (Should be a String or a Map of String-String entries)
* responseBody (String or byte[]) - If set, the request will be fulfilled with the given body.
* interceptResponse - If set to false, the corresponding response will not be intercepted.

Only available when CDP-Driver is used to connect the browser.
"""
WEB_REQUEST_RECEIVED = _WrappedUserNotifications.WEB_REQUEST_RECEIVED
"""
Simple variation of WEB_RESPONSE_RECEIVED, called upon CDPs Fetch.requestPaused event, only contains
the parsed event data as "value" entry, and the request is continued without modification.
"""
WEB_REQUEST_RECEIVED_TRACKONLY = _WrappedUserNotifications.WEB_REQUEST_RECEIVED_TRACKONLY
"""
Called as soon as a request is responded from the server to the browser.

The userInfo contains all information as described for WEB_REQUEST_RECEIVED.

In addition, the following entries are prefilled:
* errorReason - Only in case of error (replaceable)
* responseCode - If available (replaceable)
* responseHeaders - The headers returned from the server (replaceable)
* responseBodyAccessor - An object who's "get()"-Method returns the body of the response (String or byte[])

Information: Only modify the response headers or request the responseBody if the request content is
about to be small to avoid OutOfMemory errors, since the complete body will go through QF-Test
for technical reasons.

Only available when CDP-Driver is used to connect the browser.
"""
WEB_RESPONSE_RECEIVED = _WrappedUserNotifications.WEB_RESPONSE_RECEIVED
"""
Simple variation of WEB_RESPONSE_RECEIVED, called upon CDPs Fetch.requestPaused event, only contains
the parsed event data as "value" entry, and the request is continued without modification.
"""
WEB_RESPONSE_RECEIVED_TRACKONLY = _WrappedUserNotifications.WEB_RESPONSE_RECEIVED_TRACKONLY
CREATING_WEBDRIVER = _WrappedUserNotifications.CREATING_WEBDRIVER
CREATING_CDPDRIVER = _WrappedUserNotifications.CREATING_CDPDRIVER
"""
Triggered after a CDP browser has been started and the connection URL has been determined. Allows to adapt the
connection URL before the CDP connection is established.

The userInfo contains the following entries:
* url - The url used to create a websocket connection - (replaceable)

These entries can be added to the userInfo:
* connection - a com.cdp4j.channel.Connection Object which can be used in place of the
"""
PRECONNECT_CDPDRIVER = _WrappedUserNotifications.PRECONNECT_CDPDRIVER
""" The ExceptionHandler logs to run log and catches any exception"""
LOGGING_EXCEPTION_HANDLER = _WrappedUserNotifications.LOGGING_EXCEPTION_HANDLER
"""
Called if a emulator connection should be checked.

User info values:
* engineName: name of the engine(android/ios).
"""
VERIFY_EMULATOR_CONNECTION = _WrappedUserNotifications.VERIFY_EMULATOR_CONNECTION
#  redirected methods
__wrappedInstance = _WrappedUserNotifications.instance()
def post(notificationName, userInfo=None):
    """
    Posts a new notification.

    @param notficationName the name of the notification. If it does not start with "user.",
    it is prefixed with this string.
    @param userInfo An optional map of data to attach to the notification
    """
    __wrappedInstance.post(notificationName, userInfo)

def addObserver(observerName, method, *notificationNames):
    """
    Adds a notification observer with the given name for the given notificationNames

    @param observerName the name of the observer
    @param observer the method to call when a notification is posted. The method receives the name of the
    posted notification as first argument and the userInfo map as second argument. If the observer
    specifies only one argument, the userInfo map is provided as first parameter.
    @param notificationNames the names of the notifications to be informed when posted. If a name does not
    start with "user.", it is prefixed with this string. If no notification names are provided, the observerName
    is used as notification name.
    """
    __wrappedInstance.addObserver(observerName, method, notificationNames)

def removeObserver(observerName):
    """
    Removes the notification observer added before with the given name

    @param observerName the name of the observer to remove
    """
    __wrappedInstance.removeObserver(observerName)

def removeAllObserver():
    """ Remove all previously registered observers"""
    __wrappedInstance.removeAllObserver()

def listObserverNames():
    """ List the names of all registered observers"""
    return __wrappedInstance.listObserverNames()

