// {{{ copyright

/********************************************************************
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is qfs.de code.
 *
 * The Initial Developer of the Original Code is Gregor Schmid.
 * Portions created by Gregor Schmid are
 * Copyright (C) 1999 Quality First Software, Gregor Schmid.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 *******************************************************************/

// }}}

package de.qfs.lib.log;

import java.util.List;

import javax.annotation.Nullable;

//{{{ class LevelAwareLogBuilder
public class LevelAwareLogBuilder extends GenericLevelAwareLogBuilder<LevelAwareLogBuilder> {

    public LevelAwareLogBuilder(final QFLogger logger, final int level, final String method) {
        this(logger, level, method, 0, null);
    }

    public LevelAwareLogBuilder(final QFLogger logger, final int level, final String method, final int lineNumber,
                                @Nullable final List<LogObjectDumper> objectDumpers) {
        super(logger, level, method, lineNumber, objectDumpers);
    }

}

// }}}

