// {{{ copyright

/********************************************************************
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is qfs.de code.
 *
 * The Initial Developer of the Original Code is Oliver Brandt.
 * Portions created by Oliver Brandt are
 * Copyright (C) 2000 ATecoM GmbH.
 * Portions created by Gregor Schmid are
 * Copyright (C) 2000 Quality First Software, Gregor Schmid.
 * All Rights Reserved.
 *
 * Contributor(s):
 * Gregor Schmid, Quality First Software
 *
 *******************************************************************/

// }}}

package de.qfs.lib.log;

/**
 * Interface for a formatter for {@link LogEntry LogEntries}.
 *
 * @author      Oliver Brandt
 * @author      Gregor Schmid
 * @since       0.98.0
 */
public interface LogFormat
{
    /**
     * Format one {@link LogEntry LogEntry}.
     *
     * @param   entry   The LogEntry to format.
     *
     * @return  A String representation for the LogEntry.
     */
    public String format(LogEntry entry);
}
