// {{{ copyright

/********************************************************************
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is qfs.de code.
 *
 * The Initial Developer of the Original Code is Gregor Schmid.
 * Portions created by Gregor Schmid are
 * Copyright (C) 1999 Quality First Software, Gregor Schmid.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 *******************************************************************/

// }}}

package de.qfs.lib.log;

// {{{ imports

import java.util.EventListener;

// }}}

/**
 * Listener interface for changes in the log levels of an application.
 *
 * @author      Gregor Schmid
 */
public interface LogLevelListener
    extends EventListener
{
    /**
     * Notify the listener that a Logger for a formerly unknown class has
     * requested its log level, adding the class to the log level tree.
     *
     * @param   event   The LogLevelEvent holding the details.
     */
    public void classAdded(LogLevelEvent event);

    /**
     * Notify the listener that a log level has been changed.
     *
     * @param   event   The LogLevelEvent holding the details.
     */
    public void levelChanged(LogLevelEvent event);

    /**
     * Notify the listener that a log level has been unset.
     *
     * @param   event   The LogLevelEvent holding the details.
     */
    public void levelRemoved(LogLevelEvent event);

    /**
     * Sets the LogLevelCallback for the LogLevelListener.
     *
     * @param   callback        The LogLevelCallback to use to change the
     *                          log levels.
     */
    public void setLogLevelCallback(LogLevelCallback callback);
}
