// {{{ copyright

/********************************************************************
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is qfs.de code.
 *
 * The Initial Developer of the Original Code is Gregor Schmid.
 * Portions created by Gregor Schmid are
 * Copyright (C) 1999 Quality First Software, Gregor Schmid.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 *******************************************************************/

// }}}

package de.qfs.lib.log;

/**
 * A LogSource passes LogEntries through a chain of LogFilters that can
 * be added to or removed from the LogSource.
 *
 * @author      Gregor Schmid
 */
public interface LogSource
{
    /**
     * Add a LogFilter to the front of the filter chain.
     *
     * @param   filter  The filter to add.
     */
    public void addFilter (LogFilter filter);

    /**
     * Remove a LogFilter from the filter chain.
     *
     * @param   filter  The filter to remove
     */
    public void removeFilter (LogFilter filter);
}

