// {{{ copyright

/********************************************************************
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is qfs.de code.
 *
 * The Initial Developer of the Original Code is Gregor Schmid.
 * Portions created by Gregor Schmid are
 * Copyright (C) 1999 Quality First Software, Gregor Schmid.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 *******************************************************************/

// }}}

package de.qfs.lib.log;

/**
 * The LogUser interface extends LogFilter for customization. <p>
 *
 * There are two kinds of uses for a LogFilter.
 * One use is to filter out unneeded messages to avoid cluttering of
 * whatever means are used to display the logs.<p>
 *
 * The other use is to divert the LogEntries to a place other than System.err,
 * like a log file or a remote log server. Multiple filters of this kind may
 * be used together, e.g. remote logging may be combined with saving logs to a
 * log file, so it must be possible to configure the filters whether they
 * should pass on log entries they have used to the next filter.<p>
 *
 * @author      Gregor Schmid
 */
public interface LogUser extends LogFilter
{
    /**
     * Tells the LogUser to filer out logs used by it.
     */
    public final static int FILTER_USED = 0;

    /**
     * Tells the LogUser to let only logs used by it pass.
     */
    public final static int FILTER_UNUSED = 1;

    /**
     * Tells the LogUser to block all log entries.
     */
    public final static int FILTER_ALL = 2;

    /**
     * Tells the LogUser to let everything pass.
     */
    public final static int FILTER_NONE = 3;

    /**
     * Configure the LogUser's filter mode.
     *
     * @param   mode    The mode to set. Possible values are:
     * <dl>
     * <dt>FILTER_USED</dt><dd>Tells the LogUser to filer out logs used by
     * it.</dd>
     * <dt>FILTER_UNUSED</dt><dd>Tells the LogUser to let only logs used by it
     * pass. </dd>
     * <dt>FILTER_ALL</dt><dd>Tells the LogUser to block all log entries.</dd>
     * <dt>FILTER_NONE</dt><dd>Tells the LogUser to let everything pass.</dd>
     * </dl>
     */
    public void setFilterMode(int mode);
}
