// {{{ copyright

/********************************************************************
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is qfs.de code.
 *
 * The Initial Developer of the Original Code is Gregor Schmid.
 * Portions created by Gregor Schmid are
 * Copyright (C) 1999 Quality First Software, Gregor Schmid.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 *******************************************************************/

// }}}

package de.qfs.lib.log;

/**
 * The logging interface of all loggers.
 *
 * @author Yann Spoeri
 */
public interface QFLoggerInterface
{
    /**
     * Get the log level of the this logger.
     *
     * @return The log level of this logger.
     */
    int getLevel();

    /**
     * Get the name of the class that owns this logger.
     *
     * @return The name of the class that owns this logger.
     */
    String getOwnerName();
    /**
     * Log a log message.
     *
     * @param level The level of the log message to log.
     * @param timestamp The timestamp of the log message to log.
     * @param method The method of the log message to log.
     * @param message The message to log.
     */
    void log(int level, long timestamp, String method, String message);

    /**
     * Log a throwable/Exception.
     *
     * @param level The level of the log message to log.
     * @param method The method of the log message to log.
     * @param ex The Throwable/Exception to log.
     */
    void log(int level, String method, Throwable ex);

    /**
     * Log a stack dump.
     *
     * @param level The level of the log message to log.
     */
    void dumpStack(int level, String method, String formatMessage);
}
